clc; clear; 

%% Problem Data
n = 2;
rng(22)
Q = [0.3   -0.7
    -0.7    2.0];
h  = [-1; .1];%  +Q'*[17.2;5.5];

% Q = randn(2,2);
% Q = 0.5*(Q'*Q);
% h = randn(2,1);

x0 = [-0.8; 1];

% number of polygon sides
n_poly = 5;
% Ax = b, defines the polygon interior
A = zeros(n_poly,2);
b = zeros(n_poly,1);

% define polygon (n_poly points around a circle)
theta_poly = (0:(2*pi)/n_poly:2*pi);
x_poly = cos(theta_poly);
y_poly = 1.5*sin(theta_poly-pi/10);% rotate the y coord

% segments of circle define the polygon
for i = 1:n_poly

    % compute direction p = x2-x1
    p = [x_poly(i+1)-x_poly(i)
         y_poly(i+1)-y_poly(i)];

    % get the normal direction
    % rotate 90 degrees counter-clockwise
    a = [p(2),-p(1)];
    a = a/norm(a);

    A(i,:) = a;

    % offset of the polygon side
    b(i) = a*[x_poly(i); y_poly(i)];

end



%% Algorithm

alpha_start = 1;
beta = 0.8;
[x_final,data] = PGD_arm(@(x)(objective(x,Q,h)),Q,h,A,b,x0,alpha_start,beta);

fprintf('Solution found by PGD\n')
disp(x_final)
fprintf('Function value of PGD %.4e \n',0.5*x_final'*Q*x_final + h'*x_final)

% Plot the QP
figure(1),clf, hold on, box on
axis equal
title('Projected Gradient Descent')
plotregion(-A,-b,[],[],[0.8,0.8,0.8]); % plot the feasible region
obj = @(x,y) 0.5.*x.*Q(1,1).*x + 0.5.*y.*Q(2,2).*y + x.*Q(1,2).*y + x.*h(1)+y.*h(2);
fcontour(obj,'--','LineWidth',2)

% Plot computed optimum

plot(x_final(1),x_final(2,end),"hexagram",'MarkerSize',15,'MarkerFaceColor','b')



% Plot the iterates and search directions

for i= 1:(length(data.x)-1)
    plot(data.x(1,i),data.x(2,i),'ko','MarkerFaceColor','k')
    quiver(data.x(1,i),data.x(2,i),data.x(1,i+1)-data.x(1,i),data.x(2,i+1)-data.x(2,i),0,'LineWidth',2)
end


options = optimoptions('linprog','OptimalityTolerance',1e-8,'Display','off');
[~,f_star] = linprog(Q*x_final+h,A,b,[],[],[],[],options);
GAP=-(f_star-(Q*x_final+h)'*x_final);

fprintf('Final GAP value for PGD %.4e \n',GAP);

%% Newton


[x_final,data] = newton_method(@(x)(objective(x,Q,c)),Q,h,A,b,x0);

fprintf('Solution found by Interior point\n')
disp(x_final)
fprintf('Function value of Interior point %.4e \n',0.5*x_final'*Q*x_final + h'*x_final)


% Plot the QP
figure(2),clf, hold on, box on
axis equal
title('Interior point')
plotregion(-A,-b,[],[],[0.8,0.8,0.8]); % plot the feasible region
obj = @(x,y) 0.5.*x.*Q(1,1).*x + 0.5.*y.*Q(2,2).*y + x.*Q(1,2).*y + x.*h(1)+y.*h(2);
fcontour(obj,'--','LineWidth',2)

% Plot computed optimum

plot(x_final(1),x_final(2,end),"hexagram",'MarkerSize',15,'MarkerFaceColor','b')



% Plot the iterates and search directions

for i= 1:(length(data.x)-1)
    plot(data.x(1,i),data.x(2,i),'ko','MarkerFaceColor','k')
    quiver(data.x(1,i),data.x(2,i),data.x(1,i+1)-data.x(1,i),data.x(2,i+1)-data.x(2,i),0,'LineWidth',2)
end


options = optimoptions('linprog','OptimalityTolerance',1e-8,'Display','off');
[~,f_star] = linprog(Q*x_final+h,A,b,[],[],[],[],options);
GAP=-(f_star-(Q*x_final+h)'*x_final);

fprintf('Final GAP value for Interior point %.4e \n',GAP);












